/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.BrowserClassLoader;
import ice.htmlbrowser.BrowserSecurityException;
import java.io.FileDescriptor;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;

class BrowserSecurityManager
extends SecurityManager {
    private Class \u0142;

    public BrowserSecurityManager() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader != null) {
            this.\u0142 = classLoader.getClass();
        }
    }

    public Object getSecurityContext() {
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader instanceof BrowserClassLoader) {
            return BrowserClassLoader.getSecurityContext(this.currentClassLoader());
        }
        return null;
    }

    private boolean \u0142() {
        if (this.classLoaderDepth() == -1) {
            return true;
        }
        Object object = this.getSecurityContext();
        return object != null && object instanceof URL && ((URL)object).getProtocol().equals("file");
    }

    public synchronized void checkCreateClassLoader() {
        if (this.classLoaderDepth() != 2) {
            return;
        }
        if (!this.\u0142()) {
            throw new BrowserSecurityException("classloader");
        }
    }

    public synchronized void checkAccess(Thread thread) {
    }

    public synchronized void checkAccess(ThreadGroup threadGroup) {
    }

    public synchronized void checkExit(int n) {
        if (!this.\u0142()) {
            throw new BrowserSecurityException("exit", String.valueOf(n));
        }
    }

    public synchronized void checkExec(String string) {
        if (!this.\u0142()) {
            throw new BrowserSecurityException("exec", string);
        }
    }

    public synchronized void checkLink(String string) {
        switch (this.classLoaderDepth()) {
            case 2: 
            case 3: {
                throw new BrowserSecurityException("link", string);
            }
        }
    }

    public synchronized void checkPropertiesAccess() {
        if (this.classLoaderDepth() == 2) {
            throw new BrowserSecurityException("properties");
        }
    }

    public synchronized void checkPropertyAccess(String string) {
        if (this.\u0142()) {
            return;
        }
        if (this.classLoaderDepth() == 2 && "true".equalsIgnoreCase(System.getProperty("ice." + string))) {
            return;
        }
        if (string.equals("ice.htmlbrowser.verbose")) {
            return;
        }
        if (string.equals("java.home") || string.equals("java.class.path") || string.equals("user.name") || string.equals("user.home") || string.equals("user.dir")) {
            throw new BrowserSecurityException("properties attempt to access " + string);
        }
    }

    public synchronized void checkRead(String string) {
        if (!this.\u0142()) {
            throw new BrowserSecurityException("file.read", string);
        }
    }

    public void checkRead(String string, Object object) {
        if (!this.\u0142()) {
            throw new BrowserSecurityException("file.read", string);
        }
    }

    public synchronized void checkWrite(String string) {
        if (!this.\u0142()) {
            throw new BrowserSecurityException("file.write", string);
        }
    }

    public void checkDelete(String string) {
        if (!this.\u0142()) {
            throw new BrowserSecurityException("file.delete", string);
        }
    }

    public synchronized void checkRead(FileDescriptor fileDescriptor) {
        if (!this.\u0142() && !this.inClass("java.net.SocketInputStream") || !fileDescriptor.valid()) {
            throw new BrowserSecurityException("fd.read");
        }
    }

    public synchronized void checkWrite(FileDescriptor fileDescriptor) {
        if (!this.\u0142() && !this.inClass("java.net.SocketOutputStream") || !fileDescriptor.valid()) {
            throw new BrowserSecurityException("fd.write");
        }
    }

    public synchronized void checkListen(int n) {
        if (!this.\u0142()) {
            throw new BrowserSecurityException("socket.listen", String.valueOf(n));
        }
    }

    public synchronized void checkAccept(String string, int n) {
        if (!this.\u0142()) {
            throw new BrowserSecurityException("socket.accept", String.valueOf(string) + ":" + String.valueOf(n));
        }
    }

    public void checkMulticast(InetAddress inetAddress) {
        if (!this.\u0142()) {
            throw new BrowserSecurityException("checkmulticast");
        }
    }

    public void checkMulticast(InetAddress inetAddress, byte by) {
        if (!this.\u0142()) {
            throw new BrowserSecurityException("checkmulticast");
        }
    }

    public synchronized void checkConnect(String string, int n) {
        if (this.\u0142()) {
            return;
        }
        Object object = this.getSecurityContext();
        if (object != null && object instanceof URL) {
            this.checkConnect(((URL)object).getHost(), string);
            return;
        }
        throw new BrowserSecurityException("checkConnect", "To " + string + ":" + n);
    }

    private synchronized void checkConnect(String string, String string2) {
        block5: {
            try {
                this.inCheck = true;
                if (string.equals(string2)) break block5;
                try {
                    InetAddress inetAddress = InetAddress.getByName(string2);
                    InetAddress inetAddress2 = InetAddress.getByName(string);
                    if (inetAddress2.equals(inetAddress)) {
                        Object var4_5 = null;
                        this.inCheck = false;
                        return;
                    }
                    throw new BrowserSecurityException("checkConnect", "To " + string2);
                }
                catch (UnknownHostException unknownHostException) {
                    throw new BrowserSecurityException("checkConnect", "To " + string2);
                }
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                this.inCheck = false;
                throw throwable;
            }
        }
        Object var4_6 = null;
        this.inCheck = false;
    }

    public void checkConnect(String string, int n, Object object) {
        this.checkConnect(string, n);
        if (object != null) {
            if (object instanceof URL) {
                this.checkConnect(((URL)object).getHost(), string);
                return;
            }
            throw new BrowserSecurityException("checkConnect (unknown context)", "To " + string);
        }
    }

    public synchronized boolean checkTopLevelWindow(Object object) {
        return this.\u0142();
    }

    public synchronized void checkPackageAccess(String string) {
        if (this.\u0142()) {
            return;
        }
        int n = string.indexOf(46);
        while (n > 0) {
            String string2 = string.substring(0, n);
            if (Boolean.getBoolean("package.restrict.access." + string2)) {
                throw new BrowserSecurityException("checkpackageaccess", string);
            }
            n = string.indexOf(46, n + 1);
        }
    }

    public synchronized void checkPackageDefinition(String string) {
        if (this.\u0142()) {
            return;
        }
        int n = string.indexOf(46);
        while (n > 0) {
            String string2 = string.substring(0, n);
            if (Boolean.getBoolean("package.restrict.definition." + string2)) {
                throw new BrowserSecurityException("checkpackagedefinition", string);
            }
            n = string.indexOf(46, n + 1);
        }
    }

    public synchronized void checkSetFactory() {
        if (this.classLoaderDepth() != 2) {
            return;
        }
        if (!this.\u0142()) {
            throw new BrowserSecurityException("cannotsetfactory");
        }
    }

    public void checkPrintJobAccess() {
        if (!this.\u0142()) {
            throw new BrowserSecurityException("getPrintJob");
        }
    }

    public void checkSystemClipboardAccess() {
        if (!this.\u0142()) {
            throw new BrowserSecurityException("checksystemclipboardaccess");
        }
    }

    public void checkAwtEventQueueAccess() {
        if (!this.\u0142()) {
            throw new BrowserSecurityException("checkawteventqueueaccess");
        }
    }

    public void checkMemberAccess(Class clazz, int n) {
        ClassLoader classLoader;
        if (n != 0 && (classLoader = this.currentClassLoader()) != null && classLoader != clazz.getClassLoader()) {
            throw new BrowserSecurityException("checkmemberaccess");
        }
    }

    public void checkSecurityAccess(String string) {
        if (!this.\u0142()) {
            throw new BrowserSecurityException("checksecurityaccess", string);
        }
    }

    public ThreadGroup getThreadGroup() {
        ThreadGroup threadGroup;
        ClassLoader classLoader = this.currentClassLoader();
        if (classLoader != null && classLoader instanceof BrowserClassLoader) {
            BrowserClassLoader browserClassLoader = (BrowserClassLoader)classLoader;
            threadGroup = browserClassLoader.getThreadGroup();
        } else {
            threadGroup = super.getThreadGroup();
        }
        return threadGroup;
    }

    public ClassLoader currentClassLoader() {
        Class clazz = this.currentLoadedClass();
        if (clazz == null) {
            return null;
        }
        return clazz.getClassLoader();
    }

    public Class currentLoadedClass() {
        ClassLoader classLoader = null;
        Class<?>[] classArray = this.getClassContext();
        int n = 0;
        while (n < classArray.length) {
            classLoader = classArray[n].getClassLoader();
            if (classLoader != null && classLoader.getClass() != this.\u0142) {
                return classArray[n];
            }
            ++n;
        }
        return null;
    }

    public int classLoaderDepth() {
        Class<?>[] classArray = this.getClassContext();
        int n = 0;
        while (n < classArray.length) {
            ClassLoader classLoader = classArray[n].getClassLoader();
            if (classLoader != null && classLoader.getClass() != this.\u0142) {
                return --n;
            }
            ++n;
        }
        return -1;
    }
}

